﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class AI5620Meter : UserControl
    {

        AI5620_TE_Simulator.MeterManager Meter;


        public AI5620Meter()
        {
            InitializeComponent();

            cbo_ACSpeed.Items.Clear();
            foreach (AI5620_TE_Simulator.ACMeasurementSpeed Speed in Enum.GetValues(typeof(AI5620_TE_Simulator.ACMeasurementSpeed)))
            {
                cbo_ACSpeed.Items.Add(Speed);
            }
            cbo_ACSpeed.SelectedIndex = 0;

            cbo_Units.Items.Clear();
            foreach (SignalLevel.LevelSpecification Spec in Enum.GetValues(typeof(SignalLevel.LevelSpecification)))
            {
                cbo_Units.Items.Add(Spec);
            }
            cbo_Units.SelectedIndex = 0;


            cbo_DCSpeed.Items.Clear();
            foreach (AI5620_TE_Simulator.DCMeasurementSpeed Speed in Enum.GetValues(typeof(AI5620_TE_Simulator.DCMeasurementSpeed)))
            {
                cbo_DCSpeed.Items.Add(Speed);
            }
            cbo_DCSpeed.SelectedIndex = 0;


            this.EnabledChanged += new EventHandler(AI5620MeterCtrl_EnabledChanged);


        }

        void AI5620MeterCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }


        public void SetMeter(AI5620_TE_Simulator.MeterManager Meter)
        {
            this.Meter = Meter;
            RefreshControls();
        }

        private void RefreshControls()
        {
            if (Meter == null) return;
            cbo_ACSpeed.SelectedItem = Meter.AcMeasurementSpeed;
            cbo_DCSpeed.SelectedItem = Meter.DCMeasurementSpeed;
        }


        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (Meter == null) return;

                SignalLevel UnFiltered;
                SignalLevel Level;
                SignalLevel NotchLevel;
                Frequency Freq;
                DCVoltage LineVoltage;
                DCCurrent LoopCurrent;
                DCVoltage CMVoltage;

                SignalLevel.LevelSpecification Units = (SignalLevel.LevelSpecification)cbo_Units.SelectedItem;


                Meter.GetMeasurements(out UnFiltered, out Level, out Freq, out NotchLevel, out LineVoltage, out LoopCurrent, out CMVoltage);

                lbl_UnfilteredLevel.Text = UnFiltered.ToRepresentation(Units).ToString();
                lbl_Level.Text = Level.ToRepresentation(Units).ToString();
                lbl_Freq.Text = Freq.ToString();
                lbl_Notched.Text = NotchLevel.ToRepresentation(Units).ToString();
                lbl_LineVoltage.Text = LineVoltage.ToString();
                lbl_LoopCurrent.Text = LoopCurrent.ToString();
                lbl_CommonMode.Text = CMVoltage.ToString();

            }
            catch { }
        }

        private void cbo_ACSpeed_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (Meter == null) return;
            Meter.AcMeasurementSpeed = (AI5620_TE_Simulator.ACMeasurementSpeed)cbo_ACSpeed.SelectedItem;
 
        }

        private void cbo_DCSpeed_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (Meter == null) return;
            Meter.DCMeasurementSpeed = (AI5620_TE_Simulator.DCMeasurementSpeed)cbo_DCSpeed.SelectedItem;

        }



    }
}
